<?php
// Arquivo de roteamento simples para a API

$request_uri = trim($_SERVER['REQUEST_URI'], '/');
$segments = explode('/', $request_uri);

// Remove o prefixo do diretório se estiver em um subdiretório
// Exemplo: se a URL for http://dominio.com/backend/api/auth, $segments[0] será 'backend'
// Vamos assumir que a API está no diretório raiz ou que o .htaccess está configurado corretamente.

// Simulação de roteamento
if (in_array('api', $segments)) {
    $api_index = array_search('api', $segments);
    $resource = isset($segments[$api_index + 1]) ? $segments[$api_index + 1] : '';

    switch ($resource) {
        case 'auth':
            require 'api/auth.php';
            break;
        case 'ponto':
            require 'api/ponto.php';
            break;
        default:
            http_response_code(404);
            echo json_encode(array("message" => "Recurso não encontrado."));
            break;
    }
} else {
    http_response_code(404);
    echo json_encode(array("message" => "API não encontrada."));
}
?>
