<?php
// Arquivo de conexão e funções básicas do banco de dados
require_once 'config.php';

// Função para conectar ao banco de dados (redefinida para usar a função de config.php)
function connectDB() {
    return getDBConnection();
}

// Função para fechar a conexão com o banco de dados
function closeDB($conn) {
    if ($conn) {
        $conn->close();
    }
}

// Função para executar uma query e retornar o resultado (para SELECT)
function executeQuery($sql) {
    $conn = connectDB();
    $result = $conn->query($sql);
    closeDB($conn);
    return $result;
}

// Função para executar uma query de modificação (INSERT, UPDATE, DELETE)
function executeUpdate($sql) {
    $conn = connectDB();
    $result = $conn->query($sql);
    $insert_id = $conn->insert_id;
    closeDB($conn);
    return $result ? $insert_id : false;
}

// Função para preparar e executar uma query com prepared statements (melhor para segurança)
function prepareAndExecute($sql, $types, $params) {
    $conn = connectDB();
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        closeDB($conn);
        return false;
    }
    $stmt->bind_param($types, ...$params);
    $result = $stmt->execute();
    
    if (strtoupper(substr(trim($sql), 0, 6)) === 'SELECT') {
        $res = $stmt->get_result();
        $stmt->close();
        closeDB($conn);
        return $res;
    } else {
        $insert_id = $stmt->insert_id;
        $stmt->close();
        closeDB($conn);
        return $result ? $insert_id : false;
    }
}
?>
