<?php
// Arquivo de configuração do banco de dados
define('DB_HOST', 'localhost');
define('DB_USER', 'seu_usuario_db'); // Substitua pelo seu usuário do banco de dados
define('DB_PASS', 'sua_senha_db');   // Substitua pela sua senha do banco de dados
define('DB_NAME', 'seu_banco_de_dados'); // Substitua pelo nome do seu banco de dados

// Configurações de segurança (opcional, mas recomendado)
define('SECRET_KEY', 'sua_chave_secreta_para_jwt_ou_sessoes'); // Chave secreta para JWT ou sessões
define('TOKEN_EXPIRATION', 3600); // Tempo de expiração do token em segundos (1 hora)

// Configurações de caminho da API
define('BASE_URL', '/api/'); // Caminho base da API (ajuste conforme a hospedagem)

// Configurações de cabeçalhos CORS (para permitir acesso do front-end)
header("Access-Control-Allow-Origin: *"); // Permite acesso de qualquer origem (ajuste para o domínio do seu front-end em produção)
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Função para conectar ao banco de dados
function getDBConnection() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

    if ($conn->connect_error) {
        http_response_code(500);
        echo json_encode(array("message" => "Erro de conexão com o banco de dados: " . $conn->connect_error));
        exit();
    }

    $conn->set_charset("utf8mb4");
    return $conn;
}

// Função para gerar um hash de senha
function hashPassword($password) {
    return password_hash($password, PASSWORD_BCRYPT);
}

// Função para verificar um hash de senha
function verifyPassword($password, $hash) {
    return password_verify($password, $hash);
}

// Função para conectar ao banco de dados
function hashPassword($password) {
    return password_hash($password, PASSWORD_BCRYPT);
}

// Função para verificar um hash de senha
function verifyPassword($password, $hash) {
    return password_verify($password, $hash);
}
?>
