<?php
require_once '../config/config.php';
require_once '../config/db.php';
require_once '../config/JwtUtil.php';

// Função de autenticação usando JWT
function authenticate() {
    $headers = getallheaders();
    $token = null;

    // Busca o token no cabeçalho Authorization
    if (isset($headers['Authorization']) && preg_match('/Bearer\s(\S+)/', $headers['Authorization'], $matches)) {
        $token = $matches[1];
    }

    if (!$token) {
        http_response_code(401);
        echo json_encode(array("message" => "Acesso negado. Token não fornecido."));
        exit();
    }
    
    $payload = JwtUtil::validateToken($token);

    if (!$payload) {
        http_response_code(401);
        echo json_encode(array("message" => "Token inválido ou expirado."));
        exit();
    }

    return $payload['user_id']; // Retorna o ID do colaborador
}

// Define o método de requisição
$method = $_SERVER['REQUEST_METHOD'];

// Rota para registrar ponto (POST)
if ($method === 'POST') {
    $id_colaborador = authenticate(); // Autentica e obtém o ID do colaborador

    $data = json_decode(file_get_contents("php://input"));

    if (!isset($data->tipo_registro)) {
        http_response_code(400);
        echo json_encode(array("message" => "Tipo de registro é obrigatório."));
        exit();
    }

    $tipo_registro = $data->tipo_registro;
    $data_hora = date('Y-m-d H:i:s'); // Hora atual do servidor
    $localizacao_lat = isset($data->latitude) ? $data->latitude : null;
    $localizacao_lon = isset($data->longitude) ? $data->longitude : null;
    $ip_registro = $_SERVER['REMOTE_ADDR'];

    // Validação básica do tipo de registro
    $tipos_validos = ['entrada', 'saida_almoco', 'volta_almoco', 'saida'];
    if (!in_array($tipo_registro, $tipos_validos)) {
        http_response_code(400);
        echo json_encode(array("message" => "Tipo de registro inválido."));
        exit();
    }

    // Insere o registro no banco de dados
    $sql = "INSERT INTO registros_ponto (id_colaborador, tipo_registro, data_hora, localizacao_lat, localizacao_lon, ip_registro) VALUES (?, ?, ?, ?, ?, ?)";
    $insert_id = prepareAndExecute(
        $sql, 
        "isssds", 
        [$id_colaborador, $tipo_registro, $data_hora, $localizacao_lat, $localizacao_lon, $ip_registro]
    );

    if ($insert_id) {
        http_response_code(201);
        echo json_encode(array("message" => "Ponto registrado com sucesso.", "id_registro" => $insert_id, "data_hora" => $data_hora));
    } else {
        http_response_code(500);
        echo json_encode(array("message" => "Erro ao registrar o ponto."));
    }
} 
// Rota para buscar registros de ponto (GET)
else if ($method === 'GET') {
    $id_colaborador = authenticate(); // Autentica e obtém o ID do colaborador

    // Busca os últimos 10 registros do colaborador
    $sql = "SELECT * FROM registros_ponto WHERE id_colaborador = ? ORDER BY data_hora DESC LIMIT 10";
    $conn = connectDB();
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id_colaborador);
    $stmt->execute();
    $result = $stmt->get_result();
    $registros = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    closeDB($conn);

    http_response_code(200);
    echo json_encode($registros);
}
else {
    // Método não permitido
    http_response_code(405);
    echo json_encode(array("message" => "Método não permitido."));
}
?>
