<?php
require_once '../config/config.php';
require_once '../config/db.php';
require_once '../config/JwtUtil.php';

// Define o método de requisição
$method = $_SERVER['REQUEST_METHOD'];

// Lida com a requisição de login
if ($method === 'POST') {
    // Garante que o corpo da requisição seja JSON
    $data = json_decode(file_get_contents("php://input"));

    if (!isset($data->matricula) || !isset($data->senha)) {
        http_response_code(400);
        echo json_encode(array("message" => "Dados incompletos. Matrícula e senha são obrigatórios."));
        exit();
    }

    $matricula = $data->matricula;
    $senha = $data->senha;

    // Busca o colaborador pela matrícula
    $sql = "SELECT id_colaborador, nome_completo, senha_hash FROM colaboradores WHERE matricula = ?";
    $conn = connectDB();
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $matricula);
    $stmt->execute();
    $result = $stmt->get_result();
    $colaborador = $result->fetch_assoc();
    $stmt->close();
    closeDB($conn);

    if ($colaborador) {
        // **VERIFICAÇÃO DE SENHA SEGURA PARA PRODUÇÃO**
        if (verifyPassword($senha, $colaborador['senha_hash'])) {
            
            // Login bem-sucedido - Gera JWT
            $payload = [
                'user_id' => $colaborador['id_colaborador'],
                'matricula' => $matricula,
                'nome' => $colaborador['nome_completo']
            ];
            $token = JwtUtil::generateToken($payload);

            http_response_code(200);
            echo json_encode(array(
                "message" => "Login bem-sucedido.",
                "colaborador" => array(
                    "id" => $colaborador['id_colaborador'],
                    "nome" => $colaborador['nome_completo'],
                    "matricula" => $matricula
                ),
                "token" => $token
            ));
        } else {
            // Senha incorreta
            http_response_code(401);
            echo json_encode(array("message" => "Matrícula ou senha incorretas."));
        }
    } else {
        // Colaborador não encontrado
        http_response_code(404);
        echo json_encode(array("message" => "Colaborador não encontrado."));
    }
} else {
    // Método não permitido
    http_response_code(405);
    echo json_encode(array("message" => "Método não permitido."));
}
?>
