<?php
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../middleware.php';
require_once __DIR__ . '/../util.php';

requireApiKeyOrJwt();
requireMethod('GET');

$usuario_id = $_GET['usuario_id'] ?? null;
$usuario = $_GET['usuario'] ?? null;

// Se autenticado, filtra automaticamente pelo usuário logado caso não seja passado
$authUserId = getAuthUserId();
if ($authUserId && !$usuario_id && !$usuario) {
  $usuario_id = $authUserId;
}

if (!$usuario_id && !$usuario) {
  jsonResponse(['error' => 'Passe "usuario_id" ou "usuario" (ou autentique via JWT)'], 400);
}

if ($usuario_id) {
  $stmt = $pdo->prepare("SELECT * FROM pontos WHERE usuario_id = ? ORDER BY data_hora DESC LIMIT 500");
  $stmt->execute([$usuario_id]);
} else {
  $stmt = $pdo->prepare("SELECT * FROM pontos WHERE usuario = ? ORDER BY data_hora DESC LIMIT 500");
  $stmt->execute([$usuario]);
}

jsonResponse($stmt->fetchAll());
