<?php
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../middleware.php';
require_once __DIR__ . '/../util.php';

requireApiKeyOrJwt();
requireMethod('POST');

$input = getJsonBody();
$usuario_id = $input['usuario_id'] ?? null;
$usuario = $input['usuario'] ?? null;
$tipo = $input['tipo'] ?? null;
$obs = $input['obs'] ?? null;

if (!$tipo || !in_array($tipo, ['entrada','saida','intervalo','retorno'], true)) {
  jsonResponse(['error' => 'Campo "tipo" inválido'], 400);
}

// Se autenticado via JWT, preferir o usuário logado
$authUserId = getAuthUserId();
if ($authUserId) {
  $usuario_id = $authUserId;
  $usuario = null; // redundante
} elseif (!$usuario_id && !$usuario) {
  jsonResponse(['error' => 'Informe "usuario_id" ou "usuario" (ou autentique via JWT)'], 400);
}

$sql = "INSERT INTO pontos (usuario_id, usuario, data_hora, tipo, obs) VALUES (?, ?, NOW(), ?, ?)";
$stmt = $pdo->prepare($sql);
$stmt->execute([$usuario_id, $usuario, $tipo, $obs]);

jsonResponse(['ok' => true, 'id' => $pdo->lastInsertId()]);
