<?php
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../util.php';
require_once __DIR__ . '/../jwt.php';

requireMethod('POST');
$input = getJsonBody();
$email = trim($input['email'] ?? '');
$senha = strval($input['senha'] ?? '');

if ($email === '' || $senha === '') {
  jsonResponse(['error' => 'Informe email e senha'], 400);
}

$stmt = $pdo->prepare('SELECT id, nome, email, password_hash FROM usuarios WHERE email = ? LIMIT 1');
$stmt->execute([$email]);
$user = $stmt->fetch();

if (!$user || empty($user['password_hash']) || !password_verify($senha, $user['password_hash'])) {
  jsonResponse(['error' => 'Credenciais inválidas'], 401);
}

$token = jwt_new_for_user($user);
jsonResponse(['ok' => true, 'token' => $token, 'user' => ['id' => $user['id'], 'nome' => $user['nome'], 'email' => $user['email']]]);
