# API PHP com JWT para App de Ponto

## 1) Instalação
1. Suba `api/` para o servidor (ex.: `public_html/api/`).
2. Crie o DB e importe `schema.sql`.
3. Ajuste `api/config.php` (DB_* e JWT_*). Opcionalmente defina `API_KEY`.
4. Faça um teste em `GET /api/index.php` (não exige auth).

## 2) Autenticação (JWT)
- **Registro**: `POST /api/auth/register.php` — body `{ "nome": "...", "email": "...", "senha": "..." }`
- **Login**: `POST /api/auth/login.php` — body `{ "email": "...", "senha": "..." }` → retorna `{ token, user }`
- **Perfil**: `GET /api/auth/me.php` — header `Authorization: Bearer <token>`

> Também é aceito `API_KEY` como alternativa (`Authorization: Bearer <API_KEY>` ou `?key=...`).

## 3) Endpoints de negócio
- `POST /api/pontos/criar.php` — cria ponto. Se logado via JWT, usa o **usuário do token** automaticamente; caso contrário, envie `usuario_id` ou `usuario`.
- `GET /api/pontos/listar.php?limit=100`
- `GET /api/pontos/por_usuario.php?usuario_id=1` (ou `?usuario=Nome`). Se JWT e sem parâmetros, usa o ID do token.
- `GET /api/pontos/hoje.php?usuario_id=1` (ou `?usuario=Nome`). Se JWT e sem parâmetros, usa o ID do token.
- `POST /api/usuarios/criar.php` — cria usuário (opcionalmente com `email` e `senha`).
- `GET /api/usuarios/listar.php?limit=200`

## 4) Sem mudar o front
- Os endpoints existentes continuam aceitando `usuario_id`/`usuario` como antes.
- Se você começar a enviar `Authorization: Bearer <token>`, o backend associará automáticamente os pontos ao usuário logado.

## 5) Segurança
- Troque `JWT_SECRET` em `config.php`.
- Restrinja CORS (`CORS_ORIGIN`) ao seu domínio em produção.
- Use HTTPS em produção.
